package ch.frankel.blog.hibernate.model;

import static javax.persistence.CascadeType.ALL;
import static javax.persistence.GenerationType.IDENTITY;

import java.util.Date;
import java.util.Set;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * A customer.
 * 
 * @author Nicolas Frnkel
 * @since 14 juin 2009
 */
@Entity
public class Customer extends AbstractEntity {

    @Id
    @GeneratedValue(strategy = IDENTITY)
    private long id;

    @Column(name = "FIRST_NAME")
    private String firstName;

    @Column(name = "LAST_NAME")
    private String lastName;

    private Date birthDate;

    @OneToMany(mappedBy = "customer", cascade = ALL)
    private Set<Order> orders;

    @ManyToMany(mappedBy = "customers")
    private Set<Account> accounts;

    /**
     * Adds an order to this customer's. Manage bidirectional associations.
     * 
     * @param order
     */
    public void addOrder(Order order) {

        getOrders().add(order);
        order.setCustomer(this);
    }

    /**
     * Adds an account to this customer's. Manage bidirectional associations.
     * 
     * @param account
     */
    public void addAccount(Account account) {

        getAccounts().add(account);
        account.getCustomers().add(this);
    }

    /**
     * Removes an account to this customer's. Manage bidirectional associations.
     * 
     * @param account
     */
    public void removeAccount(Account account) {

        getAccounts().remove(account);
        account.getCustomers().remove(this);
    }

    public Set<Account> getAccounts() {

        return accounts;
    }

    public Date getBirthDate() {

        return birthDate;
    }

    public String getFirstName() {

        return firstName;
    }

    public long getId() {

        return id;
    }

    public String getLastName() {

        return lastName;
    }

    public Set<Order> getOrders() {

        return orders;
    }

    public void setAccounts(Set<Account> aAccounts) {

        accounts = aAccounts;
    }

    public void setBirthDate(Date aBirthDate) {

        birthDate = aBirthDate;
    }

    public void setFirstName(String aFirstName) {

        firstName = aFirstName;
    }

    public void setId(long aId) {

        id = aId;
    }

    public void setLastName(String aLastName) {

        lastName = aLastName;
    }

    public void setOrders(Set<Order> aOrders) {

        orders = aOrders;
    }

    /**
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {

        ToStringBuilder toStringBuilder = new ToStringBuilder(this, TO_STRING_STYLE).append("id", id).append(
                "lastName", lastName).append("orders", getOrders());

        return toStringBuilder.toString();
    }
}
